package easik.ui.menu;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import easik.EasikConstants;

/**
 * Filter for file browsing dialogs to ensure that only .xml files are accepted.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-07-10 Vera Ranieri
 * @version 2006-07-10 Vera Ranieri
 */
public class TexFileFilter extends FileFilter {
	/**
	 * Overloaded method, checks the file to see if it ends with .tex and returns true.
	 * false otherwise.
	 * 
	 * @param file The file being considered
	 * @return True if the file is of an acceptable type
	 */
	public boolean accept(File file) {
		if ( file.getName().endsWith(EasikConstants.TEX_FILE) ) {
			return true; 
		}		
		if (file.isDirectory()) return true;		
		return false;	
	}
	
	/**
	 * The description of this filter. *.tex will do
	 * @return The description of this filter
	 */
	public String getDescription() {
		return "*" +EasikConstants.TEX_FILE;
	}
}

